package com.example.afrishop_v3.controllers;

import com.braintreegateway.*;

import com.example.afrishop_v3.enums.DeliveryStatusEnum;
import com.example.afrishop_v3.enums.OrderStatusEnum;
import com.example.afrishop_v3.models.*;
import com.example.afrishop_v3.repository.*;
import com.example.afrishop_v3.util.DateUtil;
import com.example.afrishop_v3.util.GatewayFactory;
import com.example.afrishop_v3.util.IdUtil;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @Auther: wudepeng
 * @Date: 2021/02/27
 * @Description:Braintree支付
 */
@RestController
@RequestMapping("/braintree")
public class BraintreeController extends Controller {
    private static Logger logger = LoggerFactory.getLogger(BraintreeController.class);
    private static BraintreeGateway gateway = GatewayFactory.getlisiGateway();
    private final TbCfOrderRepository orderRepository;
    private final TbCfFinanceRepository financeRepository;
    private final NetworkRepository networkRepository;
    private final BonusRepository bonusRepository;
    private final PostRepository postRepository;
    private final UserRepository userRepository;
    private final TokenRepository tokenRepository;
    @Value("${paypal.success_page}")
    private String PAYPAL_SUCCESS_PAGE;

    @Value("${paypal.failed_page}")
    private String PAYPAL_FAILED_PAGE;

    public BraintreeController(TbCfOrderRepository orderRepository, TbCfFinanceRepository financeRepository, NetworkRepository networkRepository, BonusRepository bonusRepository, PostRepository postRepository, UserRepository userRepository, TokenRepository tokenRepository) {
        this.orderRepository = orderRepository;
        this.financeRepository = financeRepository;
        this.networkRepository = networkRepository;
        this.bonusRepository = bonusRepository;
        this.postRepository = postRepository;
        this.userRepository = userRepository;
        this.tokenRepository = tokenRepository;
    }

    @GetMapping("/getToken")
    public Map<String, String> getToken() {
        Map<String, String> map = new HashMap<>();
        //官方写new ClientTokenRequest().customerId("customerId")可以不要。
        ClientTokenRequest clientTokenRequest = new ClientTokenRequest();
        String clientToken = gateway.clientToken().generate(clientTokenRequest);
        map.put("token", clientToken);
        return map;
    }

    @PostMapping("/pay")
    public void pay(@RequestParam String orderId,
                    @RequestParam String nonce,
                    HttpServletRequest req,
                    HttpServletResponse resp) throws IOException {

        Optional<TbCfOrder> byId = orderRepository.findById(orderId);

        if (StringUtils.isBlank(orderId) || StringUtils.isBlank(nonce) || !byId.isPresent()) {
            resp.sendRedirect(PAYPAL_FAILED_PAGE);
        }
        TbCfOrder order = byId.get();
        BigDecimal orderPrice = order.getRealityPay();
        String orderInfo = order.getDeliveryName() + "'s payment information";
        TransactionRequest request = new TransactionRequest()
                .amount(orderPrice)
                .paymentMethodNonce(nonce)
                .deviceData(orderInfo)
                .options()
                .submitForSettlement(true)
                .done();

        Result<Transaction> result = gateway.transaction().sale(request);
        logger.info((JSONObject.fromObject(result).toString()));
        logger.info("=============================================");
        logger.info("支付状态：" + result.isSuccess());
        String orderId1 = result.getTarget().getOrderId();
        String id = result.getTarget().getId();
        if (result.isSuccess()) {
            logger.info("paypal支付，订单[" + order.getOrderNo() + "]支付成功");

            //1)、修改订单状态
            TbCfOrder tbCfOrder = changeOrderState(orderId1, order);

            //2)、生成支付流水
            createFinance(id, "", order);

            //生成佣金
            Optional<TbCfOrder> optional = orderRepository.findById(orderId);
            if (optional.isPresent()) {
                TbCfOrder order1 = optional.get();
                Bonus bonus = new Bonus();
                TbCfUserInfo userInfo = new TbCfUserInfo();
                userInfo.setUserId(order1.getUserId());
//                        bonus.setUserId(tbCfOrder.getUserId());
                bonus.setOrderId(orderId);
                bonus.setAmount(order1.getItemsPrice());

                logger.info("佣金-----》》》订单号：" + orderId + "=user=" + order1.getUserId() + "=price=" + order1.getItemsPrice());
                saveNetworkMarketing(bonus, order1.getUserId());
            }
            resp.sendRedirect(PAYPAL_SUCCESS_PAGE);
        } else {
            resp.sendRedirect(PAYPAL_FAILED_PAGE);
        }


    }


    @PostMapping("/creditPay")
    public void creditPay(@RequestBody FlutterWaveCard card,
                          @RequestParam String orderId,
                          HttpServletRequest req,
                          HttpServletResponse resp) throws IOException {
        Optional<TbCfOrder> byId = orderRepository.findById(orderId);
        if (StringUtils.isBlank(orderId) || !byId.isPresent()) {
            resp.sendRedirect(PAYPAL_FAILED_PAGE);
        }
        TbCfOrder order = byId.get();
//        BigDecimal orderPrice = order.getRealityPay();
        Customer customer = gateway.customer().create(new CustomerRequest()).getTarget();
        CreditCardRequest request = new CreditCardRequest().
                customerId(customer.getId()).
                cardholderName(order.getDeliveryName()).
                cvv(card.getCvv()).
                number(card.getCard()).
                expirationDate(card.getMonth() + "/" + card.getYear());//05/12
        Result<CreditCard> result = gateway.creditCard().create(request);
        if (result.isSuccess()) {
            logger.info("paypal支付，订单[" + order.getOrderNo() + "]支付成功");
            logger.info("=============================================");
            logger.info("支付状态：" + result.isSuccess());
            String customerId = result.getTarget().getCustomerId();
            String id = result.getTarget().getToken();
            String imageUrl = result.getTarget().getImageUrl();
            //1)、修改订单状态
            TbCfOrder tbCfOrder = changeOrderState(customerId, order);

            //2)、生成支付流水
            createFinance(id, imageUrl, order);

            //生成佣金
            Optional<TbCfOrder> optional = orderRepository.findById(orderId);
            if (optional.isPresent()) {
                TbCfOrder order1 = optional.get();
                Bonus bonus = new Bonus();
                TbCfUserInfo userInfo = new TbCfUserInfo();
                userInfo.setUserId(order1.getUserId());
//                        bonus.setUserId(tbCfOrder.getUserId());
                bonus.setOrderId(orderId);
                bonus.setAmount(order1.getItemsPrice());

                logger.info("佣金-----》》》订单号：" + orderId + "=user=" + order1.getUserId() + "=price=" + order1.getItemsPrice());
                saveNetworkMarketing(bonus, order1.getUserId());
            }
            resp.sendRedirect(PAYPAL_SUCCESS_PAGE);
        } else {
            resp.sendRedirect(PAYPAL_FAILED_PAGE);
        }

    }

    /**
     * 修改订单状态
     */
    private TbCfOrder changeOrderState(String transToken, TbCfOrder order) {
        //更改订单状态
        order.setUpdateTime(DateUtil.getNow());
        order.setDealTime(DateUtil.getNow());
        order.setPayId(transToken);
        order.setOrderStatus(OrderStatusEnum.PAID.getValue());
        order.setPayStatus(OrderStatusEnum.PAID.getValue());
        order.setDeliveryFlag(DeliveryStatusEnum.PROCESSING.getValue());
        return orderRepository.save(order);
    }

    private TbCfFinance createFinance(String paymentId, String url, TbCfOrder tbCfOrderVo) {
        TbCfFinance tbCfFinance = new TbCfFinance();
        tbCfFinance.setOrderId(tbCfOrderVo.getOrderId());
        tbCfFinance.setFinaceId(IdUtil.createIdbyUUID());
        tbCfFinance.setPayAccount(tbCfOrderVo.getRealityPay());
        tbCfFinance.setPayId(paymentId);
        tbCfFinance.setPayTime(new Date());
        tbCfFinance.setReceiptUrl(url);
        tbCfFinance.setPayWayCode("braintree");
        tbCfFinance.setUserId(tbCfOrderVo.getUserId());
        financeRepository.save(tbCfFinance);
        return tbCfFinance;
    }


    public String getTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String now = format.format(new Date());
        return now;
    }

    public void saveNetworkMarketing(Bonus bonus, String userId) {

        String orderId = bonus.getOrderId();

        if (orderId == null)
            logger.info("佣金：orderId为空");

        Optional<TbCfOrder> orderOptional = orderRepository.findById(orderId);

        if (!orderOptional.isPresent())
            logger.info("佣金：订单不存在");

        TbCfOrder order = orderOptional.get();

        if (!OrderStatusEnum.PAID.getValue().equals(order.getPayStatus())) {
            logger.info("佣金：订单未支付");
        }

        boolean condition = orderId != null && orderOptional.isPresent() && OrderStatusEnum.PAID.getValue().equals(order.getPayStatus()) && !StringUtils.isBlank(userId);

//        if (bonusRepository.existsByOrderId(orderId)) {
//            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Transaction already done !!!");
//        }


        BigDecimal amount = bonus.getAmount();

        if (condition) {


            Optional<TbCfUserInfo> optionalUser = userRepository.findById(userId);

            if (optionalUser.isPresent()) {

                TbCfUserInfo user = optionalUser.get();

                Post post = bonus.getPost();

                Optional<Post> postOptional = post == null ? Optional.empty() : postRepository.findById(post.getId());

                String productSharer = bonus.getProductSharer();

                Optional<TbCfUserInfo> sharer = Optional.empty();

                if (productSharer != null) {
                    sharer = userRepository.findByCode(productSharer);
                }
                synchronized (this) {
                    boolean exists = bonusRepository.existsByOrderId(orderId);
                    if (!exists && user.invited()) {
                        BigDecimal v = amount.multiply(BigDecimal.valueOf(10)).divide(BigDecimal.valueOf(100), RoundingMode.CEILING);
                        bonus.setAmount(v);
                        bonus.setUserInfo(user);
                        bonus.setPercentage(10);
                        bonus = bonusRepository.save(bonus);
                        if (user.hasFcm()) {
                            sendNotification(user.getFcm(), "Bonus alert !!", user.display() + ", You received bonus of $" + formatter.format(v) + " in your account");
                        }
                    }

                    TbCfUserInfo bonusInc = runBonusInc(user, amount, 5, false, orderId);
                    runBonusInc(sharer.orElseGet(() -> postOptional.isPresent() ? postOptional.get().getRealUser() : bonusInc), amount, 5, postOptional.isPresent() || sharer.isPresent(), orderId);
                    //runBonusInc(bonusInc, amount, 0);
                }
            }

        }


    }

    private TbCfUserInfo runBonusInc(TbCfUserInfo user, BigDecimal amount, int percent, boolean direct, String orderId) {
        if (user == null) return null;
        Optional<Network> userCode = networkRepository.findFirstByNetworkInfoCode(user.getCode());
        if (userCode.isPresent() || direct) {
            TbCfUserInfo userInfo = direct ? user : userCode.get().getUserInfo();
            Bonus bonus = new Bonus();
            bonus.setUserInfo(userInfo);
            BigDecimal v = amount.multiply(BigDecimal.valueOf(percent));
            v = v.divide(BigDecimal.valueOf(100), RoundingMode.CEILING);
            bonus.setAmount(v);
            bonus.setPercentage(percent);
            bonus.setOrderId(orderId);
            if (userInfo != null && userInfo.invited() && !"000000".equals(userInfo.getCode())) {
                bonusRepository.save(bonus);
//                bonus = repository.save(bonus);
                if (userInfo.hasFcm()) {
                    sendNotification(userInfo.getFcm(), "Bonus alert !!", userInfo.display() + ", You received bonus of $" + formatter.format(v) + " in your account");
                }
            }
            return userInfo;
        }

        return null;
    }

}
