package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.OrderStatusEnum;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.*;
import com.example.afrishop_v3.repository.*;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;

@RestController
@RequestMapping("/discover/bonus")
public class BonusController extends Controller {
    private final BonusRepository repository;
    private final TbCfStationItemRepository itemRepository;
    private final UserRepository userRepository;
    private final PostRepository postRepository;
    private final NetworkRepository networkRepository;


    //    @PersistenceContext(unitName = "afrishop_v3")
    private final EntityManager entityManager;
    private final AuthenticationUser user;
    private final TbCfOrderRepository orderRepository;

    public BonusController(BonusRepository repository, TbCfStationItemRepository itemRepository, UserRepository userRepository, PostRepository postRepository, NetworkRepository networkRepository, AuthenticationUser user, TbCfOrderRepository orderRepository, EntityManager entityManager) {
        this.repository = repository;
        this.itemRepository = itemRepository;
        this.userRepository = userRepository;
        this.postRepository = postRepository;
        this.networkRepository = networkRepository;
        this.entityManager = entityManager;
        this.user = user;
        this.orderRepository = orderRepository;
    }

    @Deprecated
    @GetMapping(value = "/listBonus")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<Bonus> getList(@RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAll(PageRequest.of(pageNo, pageSize)).toList();
    }

    @Deprecated
    @GetMapping(value = "/list/bonus/{userId}")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<Bonus> getListByUser(@PathVariable("userId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByUserInfo_UserIdOrderByCreateDateDesc(id, PageRequest.of(pageNo, pageSize)).toList();
    }

    //Get paginated list of bonus by authorized user
    @GetMapping(value = "/list")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<Bonus> getListByUser(@RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByUserInfo_UserIdOrderByCreateDateDesc(user.userId(), PageRequest.of(pageNo, pageSize)).toList();
    }

    //Get bonuses in current month
    @GetMapping(value = "/list/currentMonth")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public Map<String, Object> getListByUserAndCurrentMonth(@RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return getListByUserAndCurrentMonth(user.userId(), pageNo, pageSize);
    }

    @Deprecated
    @GetMapping(value = "/list/bonus/{userId}/currentMonth")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public Map<String, Object> getListByUserAndCurrentMonth(@PathVariable("userId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        Date date = new Date();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int month = localDate.getMonthValue();
        int year = localDate.getYear();
        Optional<TbCfUserInfo> byId = userRepository.findById(id);
        if (!byId.isPresent()) return null;
        //Calculate sum of bonus in single month
        Query nativeQuery = entityManager.createNativeQuery("select IFNULL(sum(b.amount),0.0) as data FROM bonus b where b.user_info_user_id=:user and month (b.create_date) = :month and year(b.create_date) = :year ");
        nativeQuery.setParameter("user", id);
        nativeQuery.setParameter("month", month);
        nativeQuery.setParameter("year", year);
        List<Bonus> bonuses = repository.findAllByUser_IdAndCreateDateMonthAndCreateDateYear(byId.get(), month, year, PageRequest.of(pageNo, pageSize)).toList();
        HashMap<String, Object> hashMap = new HashMap<>();
        Double singleResult = (Double) nativeQuery.getSingleResult();
        BigDecimal totalBonus = BigDecimal.valueOf(singleResult);
        hashMap.put("total", totalBonus.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalBonus.setScale(3, BigDecimal.ROUND_DOWN));
        hashMap.put("list", bonuses);
        return hashMap;
    }

    //Get bonuses from previous month
    @GetMapping(value = "/list/prevMonth")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public Map<String, Object> getListByUserAndPreviousMonth(@RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return getListByUserAndPreviousMonth(user.userId(), pageNo, pageSize);
    }

    @Deprecated
    @GetMapping(value = "/list/bonus/{userId}/prevMonth")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public Map<String, Object> getListByUserAndPreviousMonth(@PathVariable("userId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        Date date = new Date();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int month = localDate.getMonthValue() - 1;
        int year = localDate.getYear();
        //如果是1月，上个月则是去年12月
        if (localDate.getMonthValue() == 1) {
            month = 12;
            year = year - 1;
        }
        Optional<TbCfUserInfo> byId = userRepository.findById(id);
        if (!byId.isPresent()) return null;
        //Calculate sum of bonus in single month
        Query nativeQuery = entityManager.createNativeQuery("select IFNULL(sum(b.amount),0.0) as data FROM bonus b where b.user_info_user_id=:user and month (b.create_date) = :month and year(b.create_date) = :year ");
        nativeQuery.setParameter("user", id);
        nativeQuery.setParameter("month", month);
        nativeQuery.setParameter("year", year);
        List<Bonus> bonuses = repository.findAllByUser_IdAndCreateDateMonthAndCreateDateYear(byId.get(), month, year, PageRequest.of(pageNo, pageSize)).toList();
        HashMap<String, Object> hashMap = new HashMap<>();
        Double singleResult = (Double) nativeQuery.getSingleResult();
        BigDecimal totalBonus = BigDecimal.valueOf(singleResult);
        hashMap.put("total", totalBonus.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalBonus.setScale(3, BigDecimal.ROUND_DOWN));
        hashMap.put("list", bonuses);
        return hashMap;
    }

    @GetMapping(value = "/list/today")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public Map<String, Object> getListByUserAndToday(@RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return getListByUserAndToday(user.userId(), pageNo, pageSize);
    }

    @Deprecated
    @GetMapping(value = "/list/bonus/{userId}/today")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public Map<String, Object> getListByUserAndToday(@PathVariable("userId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        Date date = new Date();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int dayOfYear = localDate.getDayOfYear();
        int year = localDate.getYear();
        Optional<TbCfUserInfo> byId = userRepository.findById(id);
        if (!byId.isPresent()) return null;
        //Calculate sum of bonus for today
        Query nativeQuery = entityManager.createNativeQuery("select IFNULL(sum(b.amount),0.0) as data FROM bonus b where b.user_info_user_id=:user and dayofyear(b.create_date) = :day and year(b.create_date) = :year ");
        nativeQuery.setParameter("user", id);
        nativeQuery.setParameter("day", dayOfYear);
        nativeQuery.setParameter("year", year);
        List<Bonus> bonuses = repository.findAllByUser_IdAndCreateDate(byId.get(), dayOfYear, year, PageRequest.of(pageNo, pageSize)).toList();
        HashMap<String, Object> hashMap = new HashMap<>();
        Double singleResult = (Double) nativeQuery.getSingleResult();
        BigDecimal totalBonus = BigDecimal.valueOf(singleResult);
        hashMap.put("total", totalBonus.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalBonus.setScale(3, BigDecimal.ROUND_DOWN));
        hashMap.put("list", bonuses);
        return hashMap;
    }

    @PostMapping(value = "/saveBonus")
    public Bonus saveBonus(@ModelAttribute("Bonus") Bonus bonus) {
        String itemId = bonus.getProduct();
        Optional<TbCfStationItem> itemOptional = itemRepository.findById(itemId);
        Post post = bonus.getPost();
        if (itemOptional.isPresent()) {
            bonus.setStationItem(itemOptional.get());
        } else return null;


        String sharer = bonus.getSharer();
        BigDecimal amount = bonus.getAmount();
        bonus.setAmount(amount.multiply(BigDecimal.valueOf(5)).divide(BigDecimal.valueOf(5), RoundingMode.CEILING));
        bonus.setPercentage(5);

        if (sharer != null && userRepository.existsByCode(sharer)) {
            Optional<TbCfUserInfo> byId = userRepository.findByCode(sharer);
            if (byId.isPresent()) {
                Bonus bonus1 = new Bonus();
                bonus1.setStationItem(itemOptional.get());
                bonus1.setPost(post);
                bonus1.setUserInfo(byId.get());
                bonus1.setAmount(amount.multiply(BigDecimal.valueOf(10)).divide(BigDecimal.valueOf(100), RoundingMode.CEILING));
                bonus1.setPercentage(10.0);
                repository.save(bonus1);
            }
        }


        return repository.save(bonus);
    }

    @PostMapping(value = "/saveNetworkMarketing")
    public Result saveNetworkMarketing(@ModelAttribute("Bonus") Bonus bonus) {

        TbCfUserInfo info = user.user();

//        Optional<String> userIdOptional = bonus.userId();
//
//        String orderId = bonus.getOrderId();
//
//        if( orderId == null )
//            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"Order is missing !!!");
//
//        Optional<TbCfOrder> orderOptional = orderRepository.findById(orderId);
//
//        if( !orderOptional.isPresent() )
//            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"Order is missing !!!");
//
//        TbCfOrder order = orderOptional.get();
//
//        if( !OrderStatusEnum.PAID.getValue().equals(order.getPayStatus()) ){
//            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"Invalid order status");
//        }
//
//        if( repository.existsByOrderId(orderId) ){
//            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"Transaction already done !!!");
//        }
//
//
//        BigDecimal amount = bonus.getAmount();
//
//        if (userIdOptional.isPresent()) {
//
//            Optional<TbCfUserInfo> optionalUser = userRepository.findById(userIdOptional.get());
//
//            if (optionalUser.isPresent()) {
//
//                TbCfUserInfo user = optionalUser.get();
//
//                Post post = bonus.getPost();
//
//                Optional<Post> postOptional = post == null ? Optional.empty() : postRepository.findById(post.getId());
//
//                String productSharer = bonus.getProductSharer();
//
//                Optional<TbCfUserInfo> sharer = Optional.empty();
//
//                if( productSharer != null){
//                    sharer = userRepository.findByCode(productSharer);
//                }
//
//
//                if (user.invited()) {
//                    BigDecimal v = amount.multiply(BigDecimal.valueOf(10)).divide(BigDecimal.valueOf(100),RoundingMode.CEILING);
//                    bonus.setAmount(v);
//                    bonus.setUserInfo(user);
//                    bonus.setPercentage(10);
//                    bonus = repository.save(bonus);
//                    if( user.hasFcm() ){
//                        sendNotification(user.getFcm(),"Bonus alert !!",user.display()+", You received bonus of $"+formatter.format(v)+" in your account");
//                    }
//                }
//
//
//                TbCfUserInfo bonusInc = runBonusInc(user, amount, 5,false, orderId);
//                if (sharer.isPresent()&&sharer.get().getUserId().equals(user.getUserId())){
//                    runBonusInc(bonusInc, amount, 5,false, orderId);
//                }
//                runBonusInc(sharer.orElseGet(() -> (postOptional.isPresent()&& !postOptional.get().getUserId().equals(user.getUserId()))? postOptional.get().getRealUser() : bonusInc),
//                        amount, 5,postOptional.isPresent() || sharer.isPresent(), orderId);
//                //runBonusInc(bonusInc, amount, 0);
//            }
//        }

        return new Result<>(bonus);
    }

    private TbCfUserInfo runBonusInc(TbCfUserInfo user, BigDecimal amount, int percent, boolean direct, String orderId) {
        if (user == null) return null;
        Optional<Network> userCode = networkRepository.findFirstByNetworkInfoCode(user.getCode());
        if (userCode.isPresent() || direct) {
            TbCfUserInfo userInfo = direct ? user : userCode.get().getUserInfo();
            Bonus bonus = new Bonus();
            bonus.setUserInfo(userInfo);
            BigDecimal v = amount.multiply(BigDecimal.valueOf(percent));
            v = v.divide(BigDecimal.valueOf(100), RoundingMode.CEILING);
            bonus.setAmount(v);
            bonus.setPercentage(percent);
            bonus.setOrderId(orderId);
            if (userInfo.invited()) {
                repository.save(bonus);
                bonus = repository.save(bonus);
                if (userInfo.hasFcm()) {
                    sendNotification(userInfo.getFcm(), "Bonus alert !!", userInfo.display() + ", You received bonus of $" + formatter.format(v) + " in your account");
                }
            }
            return userInfo;
        }

        return null;
    }
}
