package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.Advertisement;
import com.example.afrishop_v3.models.TbCfStationItem;
import com.example.afrishop_v3.repository.AdvertisementItemRepository;
import com.example.afrishop_v3.repository.AdvertisementRepository;
import com.example.afrishop_v3.repository.TbCfStationItemRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Sort;

import static org.springframework.data.domain.Sort.Order.asc;
import static org.springframework.data.domain.Sort.Order.desc;

import java.util.*;

/**
 * @Auther: wudepeng
 * @Date: 2020/11/20
 * @Description:广告投放页管理
 */
@RestController
@RequestMapping("/advertisement")
public class AdvertisementController {


    private final AdvertisementRepository advertisementRepository;

    private final TbCfStationItemRepository itemRepository;


    public AdvertisementController(AdvertisementRepository advertisementRepository, TbCfStationItemRepository itemRepository) {
        this.advertisementRepository = advertisementRepository;
        this.itemRepository = itemRepository;

    }


    /**
     * 根据链接查询广告投放页
     */
    @GetMapping("/info/{link}")
    public Result getAdvertisementById(@PathVariable("link") String link,
                                       @RequestParam(value = "pageNum", defaultValue = "0") Integer pageNum,
                                       @RequestParam(value = "pageSize", defaultValue = "12") Integer pageSize,
                                       @RequestParam(value = "order", required = false) String order) {
        LinkedHashMap<String,Object> advertisementMap = new LinkedHashMap<>();
        //广告投放信息主体
        Optional<Advertisement> firstByAdLink = advertisementRepository.findFirstByAdLink(link);
        if (firstByAdLink.isPresent()) {
            Advertisement advertisement = firstByAdLink.get();
            long now = System.currentTimeMillis();
            Date endTime = advertisement.getEndTime();//结束时间

            //活动已结束
            if (now > endTime.getTime()) {
                advertisement.setStatus(3);
            }
            List<TbCfStationItem> itemList = new ArrayList<>();
            if (StringUtils.isBlank(order)) {

                itemList = itemRepository.getAdvertisementItem(advertisement.getId(), PageRequest.of(pageNum, pageSize)).toList();
            } else {
                itemList = itemRepository.getAdvertisementItem2(advertisement.getId(), PageRequest.of(pageNum, pageSize, sort(order))).toList();

            }
            advertisementMap.put("advertisement", advertisement);
            advertisementMap.put("itemList", itemList);
        }

        return new Result<>(advertisementMap);
    }

    private Sort sort(String order) {
        String col = "discountPrice";
        return Sort.by(order(order, col));
    }

    private Sort.Order order(String order, String col) {
        return "desc".equals(order) ? desc(col) : asc(col);
    }
}
