package com.example.afrishop_v3.controllers;

import com.alibaba.fastjson.JSONObject;
import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.Activity;
import com.example.afrishop_v3.models.TbCfCartRecordR;
import com.example.afrishop_v3.models.TbCfStationItem;
import com.example.afrishop_v3.repository.ActivityRepository;
import com.example.afrishop_v3.repository.TbCfCartRecordRRepository;
import com.example.afrishop_v3.repository.TbCfStationItemRepository;
import com.example.afrishop_v3.vo.Condition;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Auther: wudepeng
 * @Date: 2020/11/30
 * @Description:活动管理
 */
@RestController
@RequestMapping("/activity")
public class ActivityController {

    private final ActivityRepository activityRepository;
    private final TbCfStationItemRepository itemRepository;
    private final TbCfCartRecordRRepository cartRecordRRepository;

    public ActivityController(ActivityRepository activityRepository, TbCfStationItemRepository itemRepository, TbCfCartRecordRRepository cartRecordRRepository) {
        this.activityRepository = activityRepository;
        this.itemRepository = itemRepository;
        this.cartRecordRRepository = cartRecordRRepository;
    }

    @GetMapping("/getAllActivity")
    public Result getAllActivity(@RequestParam(value = "pageNum", defaultValue = "0") Integer pageNum,
                                 @RequestParam(value = "pageSize", defaultValue = "12") Integer pageSize) {

        return new Result(activityRepository.getAllActivity(PageRequest.of(pageNum, pageSize)));
    }

    @GetMapping("/info/{id}")
    public Result getActivityInfo(@PathVariable("id") String id) {

        return new Result(activityRepository.findById(id));
    }

    //查询商品活动
    @GetMapping("item/{itemId}")
    public Result getItemActivity(@PathVariable("itemId") String itemId) throws ParseException {
        Result result = new Result();
        Activity activity = null;
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        //全场活动
        if (activityRepository.existsByUseType(1)) {
            List<Activity> fullList = activityRepository.findAllByUseType(1);
            if (fullList != null && fullList.size() > 0)
                activity = fullList.get(0);
        }

        //商品分类活动
        if (activityRepository.existsByUseType(2)) {
            Optional<TbCfStationItem> byId = itemRepository.findById(itemId);
            if (byId.isPresent()) {
                TbCfStationItem item = byId.get();
                String category1 = item.getItemCategory();
                String category2 = item.getItemCategorytwo();
                String category3 = item.getItemDescritionId();
                String con2 = category1 + "," + category2;
                String con3 = category1 + "," + category2 + "," + category3;

                List<Activity> activityList = activityRepository.findAllByUseType(2);
                List<Activity> actList = new ArrayList<>();
                for (Activity act2 : activityList) {
                    if (category1.equals(act2.getCategoryId())) {
                        act2.setOrder(3);
                        actList.add(act2);
                    }
                    if (con2.equals(act2.getCategoryId())) {
                        act2.setOrder(2);
                        actList.add(act2);
                    }
                    if (con3.equals(act2.getCategoryId())) {
                        act2.setOrder(1);
                        actList.add(act2);
                    }
                }
                Collections.sort(actList, Comparator.comparing(Activity::getOrder));
                if (actList.size() > 0 && actList != null)
                    activity = actList.get(0);
            }

        }

        //特定商品
        if (activityRepository.existsByUseType(3)) {
            List<Activity> list = activityRepository.findAllByUseType(3);
            for (Activity act3 : list) {
                String[] itemIdArr = act3.getItemIds().split(",");
                List<String> idList = Arrays.asList(itemIdArr);
                if (idList.contains(itemId))
                    activity = act3;
                break;
            }

        }

        if (activity != null) {
            Date endTime = df.parse(activity.getEndTime().toString());
            Date now = df.parse(df.format(new Date()));
            long l = endTime.getTime() - now.getTime();
            long day = l / (24 * 60 * 60 * 1000);
            long hour = (l / (60 * 60 * 1000) - day * 24);
            long min = ((l / (60 * 1000)) - day * 24 * 60 - hour * 60);
            long s = (l / 1000 - day * 24 * 60 * 60 - hour * 60 * 60 - min * 60);
            activity.setDeadline(day + ":" + getTime(hour) + ":" + getTime(min) + ":" + getTime(s));
            result.setData(activity);
            return result;
        }
        result.setCode(ResultCodeEnum.QUERY_ERROR.getCode());
        result.setMessage("No online activity");
        return result;
    }

    public String getTime(long time) {
        String t = String.valueOf(time);
        if (time < 10) {
            t = "0" + time;
        }
        return t;
    }


    public Activity checkActivity(String itemId) {
        Result result = new Result();
        Activity activity = null;
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        //全场活动
        if (activityRepository.existsByUseType(1)) {
            List<Activity> fullList = activityRepository.findAllByUseType(1);
            activity = fullList.get(0);
        }

        //商品分类活动
        if (activityRepository.existsByUseType(2)) {
            Optional<TbCfStationItem> byId = itemRepository.findById(itemId);
            if (byId.isPresent()) {
                TbCfStationItem item = byId.get();
                String category1 = item.getItemCategory();
                String category2 = item.getItemCategorytwo();
                String category3 = item.getItemDescritionId();
                String con2 = category1 + "," + category2;
                String con3 = category1 + "," + category2 + "," + category3;

                List<Activity> activityList = activityRepository.findAllByUseType(2);
                List<Activity> actList = new ArrayList<>();
                for (Activity act2 : activityList) {
                    if (category1.equals(act2.getCategoryId())) {
                        act2.setOrder(3);
                        actList.add(act2);
                    }
                    if (con2.equals(act2.getCategoryId())) {
                        act2.setOrder(2);
                        actList.add(act2);
                    }
                    if (con3.equals(act2.getCategoryId())) {
                        act2.setOrder(1);
                        actList.add(act2);
                    }
                }
                Collections.sort(actList, Comparator.comparing(Activity::getOrder));
                if (actList.size() > 0 && actList != null)
                    activity = actList.get(0);
            }

        }
        return activity;
    }

    @PostMapping("/caculateCartDiscount")
    public Result caculateCartDiscount(@RequestBody String[] cartIds) {

        BigDecimal itemPrice = BigDecimal.ZERO;

        Map<String, Object> map = new HashMap<>();

        NumberFormat nf = NumberFormat.getInstance();

        List<Activity> fullList = activityRepository.findAllByUseType(1);

        if (fullList.size() == 0 || fullList == null)
            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "There is no online activity");

        Activity activity = fullList.get(0);
        String type = activity.getType().toString();
        List<Condition> conList = JSONObject.parseArray(activity.getCondition(), Condition.class);
        Collections.sort(conList, Comparator.comparing(Condition::getKey));

        StringBuffer msg = new StringBuffer();
        map.put("activity", activity);

        boolean exist = false;
        int itemCount = 0;
        for (String cartId : cartIds) {
            Optional<TbCfCartRecordR> byId = cartRecordRRepository.findById(cartId);
            if (byId.isPresent()) {
                exist = true;
                TbCfCartRecordR cart = byId.get();
                itemCount += cart.getItemNum();
                itemPrice = itemPrice.add(cart.getItemPrice()
                        .multiply(new BigDecimal(cart.getItemNum())));
            }
        }

        if (!exist) {
            map.put("message", activity.getContent().trim());
            return new Result(map);
        }

        BigDecimal lessAmount;
        String discount;
        for (Condition con : conList) {

            double value = con.getValue();
            double key = con.getKey();
            discount = nf.format(value);
            if ("1".equals(type)) {
                discount = "$" + discount;
            } else {
                discount = discount + "%";
            }

            if ("1".equals(type) || "2".equals(type)) {

                BigDecimal threshold = new BigDecimal(key);

                if (itemPrice.compareTo(threshold) >= 0) {
                    msg.delete(0, msg.length());
                    msg.append("Congrats, you've got " + discount + " off ! ");
                } else {
                    lessAmount = threshold.subtract(itemPrice);
                    String less = nf.format(lessAmount);
                    msg.append("Spend " + less + " more to Enjoy " + discount + " off !");
                    break;
                }
            } else if ("3".equals(type)) {

                /**
                 *
                 * 2件9折
                 * 3件8折
                 * 5件7折
                 *
                 * 如果用户购买1件商品，提示：Buy 1 more item to Enjoy 10% off !
                 * 如果用户购买2件商品，提示：Congrats, you've got 30% off ! Buy 1 more item to Enjoy 20% off !
                 *                      .
                 *                      .
                 *                      .
                 * 如果用户购大于或者等于5件商品，提示：Congrats, you've got 30% off !
                 *
                 */
                int num = (int) con.getKey();

                if (itemCount >= num) {
                    msg.delete(0, msg.length());
                    msg.append("Congrats, you've got " + discount + " off ! ");
                } else {
                    msg.append("Buy " + (num - itemCount) + " more item to Enjoy " + discount + " off !");
                    break;
                }
            }
        }


        map.put("message", msg);

        return new Result(map);
    }


}


