package com.example.afrishop_v3.bis.impl;

import com.example.afrishop_v3.bis.IItemSpider;
import com.example.afrishop_v3.enums.PlatformEnum;
import com.example.afrishop_v3.util.HttpClientUtil;
import com.example.afrishop_v3.util.JsoupUtil;
import com.example.afrishop_v3.util.TranslateHelper;
import com.example.afrishop_v3.util.ValidateUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * 天猫数据爬虫
 *
 * @author G
 */
@Component("tmItemSpider")
public class TmItemSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(TmItemSpider.class);

    /**
     * 天猫商品详情页链接
     */
    private static final String tmallUrl="https://detail.m.tmall.com/item.htm?";

    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        //主要获取id参数，组成新链接
        //targetUrl=processUrl(targetUrl);
        List<Map<String, Object>> futureList= new ArrayList<>();
        //获取url中的网页内容
        String content = HttpClientUtil.getContentByUrl(targetUrl,PlatformEnum.TM.getValue());
        //获取商品详情 观察数据可发现商品数据在 _DATA_Detail 变量中
        JSONObject infoMap= JsoupUtil.getItemDetailByName(content,"_DATA_Detail");
        JSONObject skuBaseMap= (JSONObject) infoMap.get("skuBase");
        if(!(skuBaseMap.get("props") instanceof JSONNull)) {
            JSONArray propsArray= (JSONArray) skuBaseMap.get("props");
            for(int i=0;i<propsArray.size();i++) {
                JSONObject propMap=propsArray.getJSONObject(i);
                String propName= (String) propMap.get("name");
                JSONArray valueArray=propMap.getJSONArray("values");
                //翻译属性名
                if(ValidateUtils.isContainChinese(propName)) {
                    TranslateHelper.translateText(futureList,propMap,propName);
                }
                //翻译sku title
                if(valueArray!=null&&valueArray.size()>0) {
                    for(int j=0;j<valueArray.size();j++) {
                        JSONObject valueMap=valueArray.getJSONObject(j);
                        if(valueMap!=null&&valueMap.size()>0) {
                            String skuName= (String) valueMap.get("name");
                            //翻译属性名
                            if(ValidateUtils.isContainChinese(skuName)) {
                                TranslateHelper.translateText(futureList,valueMap,skuName);
                            }
                        }
                    }

                }
            }
        }

        //等待翻译结果
        TranslateHelper.waitForResult(futureList);
        //只取其中部分信息 TODO 后续可以继续封装
        JSONObject returnJson=new JSONObject();
        returnJson.put("seller",infoMap.get("seller"));
        returnJson.put("item",infoMap.get("item"));
        returnJson.put("mock",infoMap.get("mock"));
        returnJson.put("skuBase",infoMap.get("skuBase"));
        returnJson.put("platform", PlatformEnum.TM.getValue());
        return returnJson;
    }

}
