package com.example.afrishop_v3.bis.impl;

import com.example.afrishop_v3.bis.IItemSpider;
import com.example.afrishop_v3.enums.PlatformEnum;
import com.example.afrishop_v3.vo.*;
import com.example.afrishop_v3.util.*;


import net.sf.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * OchirlySpider 数据爬虫
 * TODO 存在"暂时无货"的判断
 * @author 爱酱油不爱醋
 */
@Component("ochirlySpider")
public class OchirlySpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * 爬虫数据返回
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     * @see
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.UNDERARMOUR.getValue());
        ProductResponse productResponse = formatProductResponse(content);
        JSONObject resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }


    /**
     * 格式化返回数据
     * @param content 主要的页面数据
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(String content) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        Document document = Jsoup.parse(content);
        // 获取标题
        Elements detailEle = document.select("div[class=detail]").select("div[class=desc]");
        String pTitle = detailEle.select("h5").text();
        // 获取价格
        Elements priceEle = detailEle.select("p[class=price]");
        String fullPrice = priceEle.attr("data-list-price");
        // 获取颜色id与图片
        Elements colorEle = document.select("div[class=color]").select("ul[class=clearfix]");
        List<String> imgUrlList = colorEle.select("a").eachAttr("href");
        List<String> pColorNoList = new ArrayList<>();
        for (int i = 0; i < imgUrlList.size(); i++) {
            String hrefStr = imgUrlList.get(i);
            if (hrefStr.contains("/p/mobile/")) {
                String[] spilt = hrefStr.split("/mobile/");
                pColorNoList.add(spilt[1].replaceAll(".shtml", ""));
            } else {
                pColorNoList.add(0, priceEle.attr("data-sku"));
            }
        }
        List<String> pColorList = new ArrayList<>();
        pColorList.addAll(pColorNoList);
        List<String> pImgList = colorEle.select("img").eachAttr("src");
        // 获取尺码
        Elements sizeEle = document.select("div[class=size]").select("div[class=size_contain]").select("li");
        List<String> pSizeList = new ArrayList<>();
        List<String> pSizeNoList = new ArrayList<>();
        for (Element element : sizeEle) {
            if (element.hasAttr("data-size-id")) {
                pSizeList.add(element.text());
                pSizeNoList.add(element.attr("data-size-id"));
            }
        }
        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        itemInfo.setShopName("Ochirly");
        itemInfo.setShopUrl("www.ochirly.com");
        itemInfo.setItemId(detailEle.select("p[class=price]").attr("data-sku"));
        itemInfo.setTitle(pTitle);
        itemInfo.setPic(pImgList.get(0));
        //////////////////////////////////// 获取商品基本信息End /////////////////////////

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////
        for (int i = 0; i < pColorList.size(); i++) {
            String colorNo = pColorList.get(i);
            String color = pColorNoList.get(i);
            String imgUrl = pImgList.get(i);

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropName(colorNo);
            productPropColor.setPropId(color);
            productPropColor.setImage(imgUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }

            ///////////////////////// 获取商品尺码属性 ////////////////////
            for (int j = 0; j < pSizeList.size(); j++) {
                String sizeNo = pSizeNoList.get(j);
                String size = pSizeList.get(j);

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }

                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 设置库存id
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }

                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSellableQuantity(999);
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);

                // TODO 转换汇率，目前商品单位是人民币
                String originalFullPrice = SpiderUtil.exchangeRate(fullPrice);

                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(originalFullPrice);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(originalFullPrice);
                productResponse.setSalePrice(originalFullPrice + "-" + originalFullPrice);
            }
        }
        //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("Ochirly");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}