package com.example.afrishop_v3.bis.impl;

import com.example.afrishop_v3.bis.IItemSpider;
import com.example.afrishop_v3.enums.PlatformEnum;
import com.example.afrishop_v3.vo.*;
import com.example.afrishop_v3.util.*;


import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Massimo Dutti 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("massimoduttiSpider")
public class MassimoduttiSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * Massimo Dutti 数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 截取链接中商品的 id
        String[] split = targetUrl.split(".html");
        String pUrl = split[0];
        int pChar = pUrl.lastIndexOf("p");
        String pId = pUrl.substring(pChar + 1);
        String dataUrl = "https://www.massimodutti.cn/itxrest/2/catalog/store/35009478/30359500/category/0/product/" + pId + "/detail?languageId=-7&appId=1";
        String content = HttpClientUtil.getContentByUrl(dataUrl, PlatformEnum.MASSIMODUTTI.getValue());
        JSONObject resultObj = JSONObject.fromObject(content);
        ProductResponse productResponse = formatProductResponse(resultObj, pId);
        resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     * @param dataMap 主要的 json 数据
     * @param pId 商品链接的 id
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(JSONObject dataMap, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSetColor = new HashSet<>(16);
        Set<ProductProp> sizePropSetSize = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////////////////////
        itemInfo.setShopName("MassimoDutti");
        itemInfo.setShopUrl("https://www.massimodutti.cn/cn/");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(dataMap.getString("name"));
        //////////////////////////////////// 获取商品基本信息End(图片下取) ////////////////////////////////////////////

        // 取 detail 节点对象
        JSONObject detailObj = dataMap.getJSONObject("detail");
        // 取 colors 节点数组
        JSONArray colorsArr = detailObj.getJSONArray("colors");
        for (int i = 0; i < colorsArr.size(); i++) {
            JSONObject colorsObj = colorsArr.getJSONObject(i);

            JSONObject imageObj = colorsObj.getJSONObject("image");
            String imageUrl = "https://static.massimodutti.cn/3/photos"
                    + imageObj.getString("url")
                    + "_2_5_16.jpg?t="
                    + imageObj.getString("timestamp");

            if (i == 0) {
                itemInfo.setPic(imageUrl);
            }

            //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
            String colorNo = colorsObj.getString("id");
            String color = colorsObj.getString("name");

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(color);
            productPropColor.setImage(imageUrl);
            propSetColor.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSetColor);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSetColor.addAll(oldPropSet);
                productPropSet.put("颜色", propSetColor);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            ///////////////////////// 获取商品尺码属性 ////////////////////
            // 取 sizes 节点对象
            JSONArray sizesArr = colorsObj.getJSONArray("sizes");
            for (int j = 0; j < sizesArr.size(); j++) {
                JSONObject sizesObj = sizesArr.getJSONObject(j);

                String sizeNo = sizesObj.getString("sku");
                String size = sizesObj.getString("name");

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropName(size);
                productPropSize.setPropId(sizeNo);
                sizePropSetSize.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSetSize);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSetSize.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSetSize);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 库存 id
                String skuStr = ";" + colorNo + ";" + sizeNo;

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(999);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                String fullPrice = sizesObj.getString("price");
                BigDecimal priceOld = new BigDecimal(fullPrice);
                BigDecimal div = new BigDecimal("100");
                BigDecimal priceNew = priceOld.divide(div, 2, BigDecimal.ROUND_HALF_UP);
                fullPrice = SpiderUtil.exchangeRate(priceNew.toString());

                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(fullPrice);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }

        // 按照一下顺序进行 json 数据的填充
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("MassimoDutti");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
