package com.example.afrishop_v3.bis.impl;

import com.example.afrishop_v3.bis.IItemSpider;
import com.example.afrishop_v3.enums.PlatformEnum;
import com.example.afrishop_v3.vo.*;
import com.example.afrishop_v3.util.*;


import net.sf.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

import static com.example.afrishop_v3.util.SpiderUtil.exchangeRate;

/**
 * Abercrombie&Fitch 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("aberCrombieFitchSpider")
public class AberCrombieFitchSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(PullandbearSpider.class);

    /**
     * Abercrombie&Fitch  数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ABERCROMBIEFITCH.getValue());
        ProductResponse productResponse = formatProductResponse(content);
        JSONObject resultJson = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultJson);
        return resultJson;
    }

    /**
     * 正则匹配是否为商品详情页的链接
     * TODO 正则编写
     * @param targetUrl url路径
     * @return 匹配失败则返回错误信息
     */
    private boolean urlPattern(String targetUrl) {
        String regex = "";
        return Pattern.matches(regex, targetUrl);
    }

    /**
     * 格式化返回数据
     * @param content 主要的页面数据
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(String content) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 无库存信息
        productResponse.setStockFlag(false);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        // 解析为 Document 对象
        Document document = Jsoup.parse(content);

        String pId = document.select("div[class=find-in-store display-none]").attr("pid");

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        itemInfo.setShopName("Abercrombie&Fitch");
        itemInfo.setShopUrl("https://www.abercrombie.cn/");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(document.select("meta[property=og:title]").attr("content"));
        itemInfo.setPic(document.select("input[id=shoppingcartpic]").attr("value"));
        //////////////////////////////////// 获取商品基本信息End /////////////////////////

        String fullPrice = document.select("meta[property=og:price:amount]").attr("content");
        fullPrice = exchangeRate(fullPrice);

        Elements colorsEle = document.select("ul[class=swatches color]").select("li");
        Elements sizesEle = document.select("ul[class=product__sizes]")
                .select("ul[class=swatches option va_1mprmry]").select("li");

        for (int i = 0; i < colorsEle.size(); i++) {
            //////////////////////////////////// 获取商品颜色属性 ////////////////////////////
            String colorNo = i + "";
            String color = colorsEle.get(i).attr("title");

            String dataLgimg = colorsEle.select("span").attr("data-lgimg");
            JSONObject datLgimgObj = JSONObject.fromObject(dataLgimg);
            String imgUrl = datLgimgObj.getString("url");

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(color);
            productPropColor.setImage(imgUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            for (Element sizeEle : sizesEle) {
                ///////////////////////// 获取商品尺码属性 ////////////////////
                String sizeNo = sizeEle.attr("title");
                String size = sizeNo;

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 库存对应的id(颜色id + 尺码id)
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }

                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(999);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(fullPrice);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                //////////////////////////////////// 获取原始价 END///////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("Abercrombie&Fitch");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
